from flask import Flask
from flask_cors import CORS

def create_app():
    app = Flask(__name__)
    app.config['UPLOAD_FOLDER'] = 'app/static/uploads'
    app.config['RESULT_FOLDER'] = 'app/static/results'

    CORS(app)

    from .routes import api
    app.register_blueprint(api)

    return app
